/* longdivmod.c
   These methods provide long division and moduls.
   change log:
   12/26/2023 initial version
   02/24/2024 broad changes for cache and dylib
   01/08/2025 added no inline directives for the included methods
*/

#include <dylib.h>
#include <longdivmod.h>

void __attribute__ ((noinline)) divmod_s32 (long numerator, long denominator) {

   long sign = 1;
   long t;

   dylib.quotient_s32_cache  = 0;
   dylib.remainder_s32_cache = 0;

   if (numerator < 0) {
      sign      = sign * -1;
      numerator = -numerator;
   }

   if (denominator < 0) {
      sign        = sign * -1;
      denominator = -denominator;
   }

   for (int i = 31 ; i >= 0; i--) {
      dylib.remainder_s32_cache = dylib.remainder_s32_cache << 1;
      t                   = (long) 1 << i;
      t                   = t & numerator; 
      t                   = t >> i;
      dylib.remainder_s32_cache = dylib.remainder_s32_cache | t;
      if (dylib.remainder_s32_cache >= denominator) {
         dylib.remainder_s32_cache = dylib.remainder_s32_cache - denominator;
         dylib.quotient_s32_cache  = dylib.quotient_s32_cache | ((long) 1 << i);
      }
   }

   dylib.quotient_s32_cache = dylib.quotient_s32_cache * sign;
}

long __attribute__ ((noinline)) __divdi3 (long numerator, long denominator) {
   if (numerator != dylib.numerator_s32_cache || denominator != dylib.denominator_s32_cache) {
      dylib.numerator_s32_cache   = numerator;
      dylib.denominator_s32_cache = denominator;
      divmod_s32 (dylib.numerator_s32_cache, dylib.denominator_s32_cache);
   }
   return dylib.quotient_s32_cache;
}

long __attribute__ ((noinline)) __moddi3 (long numerator, long denominator) {
   if (numerator != dylib.numerator_s32_cache || denominator != dylib.denominator_s32_cache) {
      dylib.numerator_s32_cache   = numerator;
      dylib.denominator_s32_cache = denominator;
      divmod_s32 (dylib.numerator_s32_cache, dylib.denominator_s32_cache);
   }
   return dylib.remainder_s32_cache;
}
