/* ltoa.c 
   This method converts from a long to its ascii representation.
   change log:
   06/23/2023 initial version
   12/29/2023 removed test for values above nine when generating display digit -- leftover from type to hex conversion
*/

#include <conversion.h>

static const long div_mod_pvd[10] = {1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
// signed long to string conversion. This method is extremely inefficient due to emulated div and mod
const char *ltoa (long x) {
  static char strbuf[16];
  char *out = strbuf;
  int digit;
  int has_first_digit = 0;
  int i;
  int si;

  // absolute value
  if (x < 0) {
    *(out++) = '-';
    x = -x;
  }

  // speed up this inefficient method by determining which div_mod_pvd index from which to start
  si = 10;
  for (i = 0; i < 10; i++) {
     if (x >= div_mod_pvd[i]) {
        si = i;
        break;
     }
  }

  // walk through every required digit index, starting at si
  for (i = si; i < 10; i++) {
     digit = 0;
     while (x >= div_mod_pvd[i]) {
        digit++;
        x -= div_mod_pvd[i];
     }
     if (digit > 0) has_first_digit = 1;
     if (has_first_digit) {
//      if (digit > 9) digit = 17;
        *(out++) = '0' + (char) digit;
     }
  }

  // after all the above, if no first digit as found, then the input value is zero
  if (!has_first_digit) {
     *(out++) = '0';
  }

  *(out) = 0;

  return strbuf;
}
