const unsigned int *fdp_reserved_low_addr = (unsigned int *) 0x8370;
unsigned int malloc_vdp_addr = 0x0000;

unsigned int malloc_vdp (int len) {

   // determine if the FDC reserved area has been collected. This value with be 0x0000 if not
   if (!malloc_vdp_addr) {
      // capture the location of the FDC reserved area
      malloc_vdp_addr = *fdp_reserved_low_addr + 1;
   }

   // ensure the length is even so allocations will be even aligned
   if (len % 2) {
      len++;
   }

   // allocate the memory and capture the bottom address
   malloc_vdp_addr -= len;

   // finally return the address of the allocated memory
   return malloc_vdp_addr;
}
