/* mkdir.c
   This method performs a unix compliant make directory operation.
   change history
   05/24/2025 initial version
   05/29/2025 updated to allow the DSRL2 result to flow out
*/

#include <dsrl2_private.h>
#include <sys/stat.h>
#include <dirent.h>
#include <libgen.h>
#include <string.h>
#include <dylib.h>

int mkdir (const char *path, unsigned int mode) {

   int r = 1;

   // Note: it is necessary to ensure that the parent exists as there is a bug in the DSR that a subsequent set_directory will succeeed even when the path doesn't exist.
   // Example: set_directory WDS1.home.marko.       (exists)
   //          mkdir         abc
   //          set_directory WDS1.home.marko.xyz.   (doesn't exist)
   //          mkdir         123
   // Note: it is necessary to ensure that the path doesn't exist at all as there is a bug in the DSR. It is actually possible to
   //       have both a file and directory with the same name within a parent directory. Shnikes!
   DIR *d;
   struct dirent *e;
   bool found = false;

   // ensure the parent directory exists
   d = opendir (dirname ((char *) path));
   if (d) {
      // determine if the path exists
      while ((e = readdir (d))) {
         if (!dylib.strcmp (basename ((char *) path), e->d_name)) {
            found = true;
            break;
         }
      }
      closedir (d);

      if (found) {
         r = 2;
      } else {
         r = dsrl2_mkdir (path);
      }
   }

   return r;
}
