/* mouse_init.c
   This method initializes the mouse.
   change history
   04/16/2025 initial version
   04/18/2025 integrated mouse_update call into mouse_get
              corrected mouse_init return
   04/21/2025 added test for mouse availability in mouse_init
              added mouse_center
   04/24/2025 added boot status display
   05/03/2025 breakout from mouse.c
   06/02/2025 added test for TIPI services use
   06/14/2025 removed test for configuration file as mouse support is moved to ms_drv
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   07/05/2025 dylib adjustments
   10/13/2025 changed ref from file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <stdio_private.h>
#include <mouse.h>
#include <mouse_private.h>
#include <tipi_mouse.h>
#include <tipi_msg.h>
#include <dylib.h>

int mouse_init () {
   int r = 1;

   if (file_get_dsr_cru ("TIPI")) {    // ensure there's a TIPI -- it will have a cru

      tipiMouseAvailable();
      r = !mousedata[0];

      if (!r) {
         mouse_center ();
      }
   }

   return r;
}
