/* mouse_update.c
   This method updates the mouse data.
   change history
   04/16/2025 initial version
   04/18/2025 integrated mouse_update call into mouse_get
              corrected mouse_init return
   04/21/2025 added test for mouse availability in mouse_init
              added mouse_center
   04/24/2025 added boot status display
   05/03/2025 breakout of mouse.c
*/

#include <mouse.h>
#include <mouse_private.h>
#include <tipi_mouse.h>

void mouse_update () {
   tipiMouseRead ();

   if (mousex) {
      pointerx += (mousex << 1) / 3;
      if (pointerx > 0xF000) {
         pointerx = 0;
      } else if (pointerx > 255) {
         pointerx = 255;
      }
   }

   if (mousey) {
      pointery += (mousey << 1) / 3;
      if (pointery > 0xF000) {
         pointery = 0;
      } else if (pointery > 191) {
         pointery = 191;
      }
   }

   if (mouseb) {
      button_left   = mouseb & MB_LEFT;
      button_middle = mouseb & MB_MID;
      button_right  = mouseb & MB_RIGHT;
   }
}
