/* passwd_get_value.c
   This method returns the value for the requested key for a given user.
   11/13/2023 initial version
   11/25/2023 updated to use the accts package
   12/10/2023 added reference to conversion.h
   03/01/2024 updated to use dylib
*/

#include <unistd_private.h>
#include <accts_private.h>
#include <string.h>
#include <conversion.h>
#include <dylib.h>

bool passwd_get_value (const char *logname, int passwd_key, char *value) {

   bool r = false;                                  // set the default return to failed
   int ra;

   accts_t accts;
   accts_init (&accts);
   ra = accts_read (&accts);

   if (!ra) {
      int i;
      ra = accts_get_value (&accts, logname, passwd_key, value, &i);
      if (!ra) {
         if (passwd_key == PASSWD_UID || passwd_key == PASSWD_GID) {
            dylib.strcpy (value, dylib.int2str (i));
         }
         r = true;
      }
      accts_free (&accts);
   }

   return r;                                        // return the result
}
