/* passwd_login_is_valid.c
   This method confirms if a username/password combination is valid.
   11/12/2023 initial version
   11/25/2023 updated to use the accts package
   12/10/2023 removed reference to string_ext.h
   03/01/2024 updated to use dylib
*/

#include <unistd_private.h>
#include <accts_private.h>
#include <cipher.h>
#include <string.h>
#include <dylib.h>

bool passwd_login_is_valid (char *username, char *password) {
   bool r = false;

   accts_t accts;
   int ra;

   accts_init (&accts);
   ra = accts_read (&accts);
   if (!ra) {
      char cipher[32];
      cipher_vic_encrypt (password, cipher, sizeof (cipher));
      char s[32];
      int i;
      ra = accts_get_value (&accts, username, PASSWD_CIPHER, s, &i);
      if (!ra) {
         r = !dylib.strcmp (cipher, s);
      }
      accts_free (&accts);
   }

   return r;
}
