/* passwd_update_cipher.c
   This method updates the password file with the user's new password cipher.
   11/12/2023 initial version
   11/25/2023 updated to use accts package
*/

#include <unistd_private.h>
#include <accts_private.h>
#include <constants.h>

int passwd_update_cipher (const char *name, const char *passwd_cipher) {

   int r = UNDEFINED;

   accts_t accts;
   int ra;

   accts_init (&accts);
   ra = accts_read (&accts);

   if (!ra) {
      ra = accts_set_value (&accts, name, PASSWD_CIPHER, passwd_cipher, 0);
      if (!ra) {
         ra = accts_write (&accts);
         if (!ra) {
            r = 0;
         }
      }
      accts_free (&accts);
   }

   return r;
}
