/* paths_differ.c
   This method returns true if two final DSR-level paths differ.
   change history
   06/02/2025 initial version
*/

#include <unistd_private.h>
#include <dylib.h>

bool paths_differ (const char *path1, const char *path2, bool are_dirs) {
   char path1_ti[FILENAME_MAX];
   char path2_ti[FILENAME_MAX];
   dylib.generate_final_path (path1_ti, (char *) path1, are_dirs);
   dylib.generate_final_path (path2_ti, (char *) path2, are_dirs);
   return dylib.strcmp (path1_ti, path2_ti);
}
