/* printf.c
   This method prints a formatted string to stdout.
   change log:
   06/23/2023 initial version
   01/20/2025 updated to use dylib.fputs
*/

#include <stdio.h>
#include <dylib.h>

int printf (const char *fmt, ...) {
    int r;
    char s[256];
    va_list argp;
    va_start (argp, fmt);
    r = vsprintf (s, fmt, argp);
    dylib.fputs (s, stdout);
    va_end (argp);
    return r;
}
