/* proc_add.c
   This method adds a process to be executed. 
   change log:
   06/23/2023 initial version
   08/05/2023 added handling of cwd.
   08/11/2023 modified to use system cache for proc list
   08/14/2023 updated for unix paths
   09/03/2023 removed hardcoding and replaced with get_root_fs_
   11/15/2023 removed use of get_root_fs_
   11/16/2023 removed dead code
   11/21/2023 removed writing of cwd
   12/10/2023 removed reference to string_ext.h
              added reference to conversion.h
   02/24/2024 broad changes for cache and dylib
   03/01/2024 modified to use dylib
              modified to write string constants to dylib.fputs
   01/07/2025 updated to write text files riding on binary for the process def files
   01/20/2025 updated fputs to dylib
*/

#include <string.h>
#include <conversion.h>
#include <stdio.h>
#include <cache_private.h>
#include <unistd.h>
#include <unistd_private.h>
#include <stdio_private.h>
#include <dylib.h>

void proc_add (const char *stdin_path, const char *stdout_path, const char *stderr_path, int argc, const char *argv[]) {

   const char *cr = "\n";

   int nextpid;
 
   if (!cache.proc_list.count) {
      nextpid = 1;
   } else {
      nextpid = cache.proc_list.id[cache.proc_list.count - 1] + 1;
   }

   cache.proc_list.id[cache.proc_list.count] = nextpid;
   cache.proc_list.count++;

   // open this process file
   char tpath[FILENAME_MAX];
   FILE *f = dylib.fopen (dylib.proc_get_pid_path (nextpid, tpath), "wb");

   // write number of arguments
   dylib.fputs (dylib.int2str (argc), f);
   dylib.fputs (cr, f);

   // write arguments
   for (int i = 0; i < argc; i++) {
      dylib.fputs (argv[i], f);
      dylib.fputs (cr, f);
   }

   // write stdin path
   if (stdin_path) {
      dylib.fputs (stdin_path, f);
   }
   dylib.fputs (cr, f);

   // write stdout path
   if (stdout_path) {
      dylib.fputs (stdout_path, f);
   }
   dylib.fputs (cr, f);

   // write stderr path
   if (stderr_path) {
      dylib.fputs (stderr_path, f);
   }
   dylib.fputs (cr, f);

   // close the process file
   dylib.fclose (f);
}
