/* proc_exec_next_ea5.c
   This method executes the next EA5 program or shell if no other programs (commands) remain.
   change log:
   06/01/2023 initial version
   08/05/2023 renamed SHELL to SH.
   08/11/2023 modified to use system cache for proc list
   08/14/2023 simplified method and removed alternate call to start the shell if no processes are queued.
              The starting of the shell is moved to to init's main program.
   11/21/2023 updated to use FILENAME_MAX
   12/10/2023 removed reference to string_ext.h
   02/11/2024 updated to load EA5 programs through the UNIX EA5 interface
   02/24/2024 broad changes for cache and dylib
   01/07/2025 updated to use text riding on binary files
*/

#include <string.h>
#include <stdio.h>
#include <unistd_private.h>
#include <cache_private.h>

void proc_exec_next_ea5 () {

   FILE *f;
   char path[FILENAME_MAX];

   if (cache.proc_list.count) {
      char tpath[FILENAME_MAX];
      f = fopen (proc_get_pid_path (cache.proc_list.id[0], tpath), "rb");
      fgets (path, sizeof (path), f);
      fgets (path, sizeof (path), f);
      fclose (f);
      path[strcspn (path, "\r\n")] = 0x00;                     // remove CR/LF
      exec_uea5 (path);
   }
}
