/* proc_get_pid_path.c
   This method returns the path for a process given its id.
   change log:
   06/23/2023 initial version
   08/14/2023 updated for unix paths
   09/02/2023 removed hard-coded root filesystem path
   11/15/2023 removed use of get_root_fs_
   11/16/2023 removed dead code
   11/21/2023 updated to use FILENAME_MAX
   12/10/2023 removed reference to string_ext.h
              added reference to conversion.h
   02/24/2024 broad changes for cache and dylib
   02/25/2024 removed const from method prototype
*/

#include <string.h>
#include <conversion.h>
#include <stdio_private.h>
#include <unistd_private.h>

char *proc_get_pid_path (int pid, char *path) {
   strcpy (path, "/proc/");
   strcat (path, int2str (pid));
   return path;
}
