/* ptoa_lower.c
   This method converts the value at the referenced location to ascii hex for the specified width.
   06/07/2025 initial version, copied/updated from ptoa_upper.c
*/

#include <conversion.h>

const char *ptoa_lower (void *d, int width) {

   static char strbuf[32];
   int p = 0;

   unsigned char * v;     
   int i;

   v = (unsigned char *) d;
  
   for (int j = 0; j < width; j++) {
   
      i = (*v & 0xF0) >> 4;
      if (i > 9) i += 39;
      strbuf[p] = '0' + i;
      p++;

      i = *v & 0x0F;
      if (i > 9) i += 39;
      strbuf[p] = '0' + i;
      p++;
  
      v++;
   }
   strbuf[p] = 0;

   return strbuf;
}
