/* ptoa_upper.c
   This method converts the value at the referenced location to ascii hex for the specified width.
   06/23/2023 initial version
   06/07/2025 renamed from ptoa to ptoa_upper
*/

#include <conversion.h>

const char *ptoa_upper (void *d, int width) {

   static char strbuf[32];
   int p = 0;

   unsigned char * v;     
   int i;

   v = (unsigned char *) d;
  
   for (int j = 0; j < width; j++) {
   
      i = (*v & 0xF0) >> 4;
      if (i > 9) i += 7;
      strbuf[p] = '0' + i;
      p++;

      i = *v & 0x0F;
      if (i > 9) i += 7;
      strbuf[p] = '0' + i;
      p++;
  
      v++;
   }
   strbuf[p] = 0;

   return strbuf;
}
