/* raise.c
   This method raises a signal to the appropriate signal handler, ignoring any that are set to ignore.
   change history
   06/05/2025 initial version
*/

#include <signal.h>
#include <cache_private.h>

int raise (int sig) {

   int r = 0;
   sig_t handler = SIG_IGN;

   switch (sig) {
      case SIGHUP:
         handler = cache.signal_handler.sighup;
         break;
      case SIGINT:
         handler = cache.signal_handler.sigint;
         break;
      case SIGKILL:
         handler = cache.signal_handler.sigkill;
         break;
      case SIGUSR1:
         handler = cache.signal_handler.sigusr1;
         break;
      case SIGUSR2:
         handler = cache.signal_handler.sigusr2;
         break;
      default:
         r = 1;
         break;
   }

   if (!r && (handler != SIG_IGN)) {
      handler (sig);
   }

   return r;
}
