/* rand.c
   This package provides basic random using LCG.
   limitations
   - the package uses 16 bit values so random is somewhat limited
   - the package uses LCG which is a good algorithm but requires one of each of multiply, modulus and add. multiply and modulus
     are extremely slow on the TMS9900 microprocessor
   change history
   05/17/2025 initial version
*/

#include <stdlib.h>

// LCG parameters suitable for 16-bit integers
#define A 75
#define C 74
#define M 65536  // 2^16

// random seed value
unsigned int rand_seed = 12345;  // Initial seed (can be any 16-bit value)

// pseudo-random number generator (16-bit LCG)
unsigned int rand () {
   rand_seed = (unsigned int)((A * rand_seed + C) % M);
   return rand_seed;
}

void srand (unsigned int s) {
   rand_seed = s;
}
