/* readdir.c
   This method reads a directory entry using an open handle.
   06/23/2023 initial version
   11/23/2023 updated to use separate dsr
   02/24/2024 broad changes for cache and dylib
   02/25/2024 modified to use cache.dir_in_use
   01/22/2025 performance improvements
*/

#include <vdp.h>
#include <stdio.h>
#include <dirent.h>
#include <dirent_private.h>
#include <conversion.h>
#include <spinner_private.h>
#include <cache_private.h>
#include <dylib.h>

struct dirent *readdir (DIR *dirp) {
   struct dirent *r;

   if (cache.dir_in_use) { 
 
      dylib.spinner_read ();
  
      dylib.spinner_write ();

      dir.df->dsr->pab.OpCode = DSR_READ;
      dylib.dsrlnk (&dir.df->dsr->pab, dir.df->dsr->vdp_pab_buffer_addr);

      char buf[150];

      // get the length of the read data
      vdpmemread (dir.df->dsr->vdp_pab_buffer_addr + 5, (unsigned char *) &dir.df->dsr->pab.CharCount, 1);

      // copy the read data from vdp to ram
      vdpmemread (dir.df->dsr->vdp_data_buffer_addr, (unsigned char *) buf, dir.df->dsr->pab.CharCount);

      char *cursor = buf;
      char len;
      
      cursor = memcpy_cursor (&len, cursor, sizeof (char));
      if (len) {
      
         cursor = memcpy_cursor (dir.entry.d_name, cursor, len);
         dir.entry.d_name[(int) len] = 0x00;
      
         cursor = memcpy_cursor (&len, cursor, sizeof (char));
         cursor = memcpy_cursor ((char *) &dir.entry.d_type, cursor, sizeof (double));
         if (dir.entry.d_type >= 0) {
            dir.entry.d_protected = false;
         } else {
            dir.entry.d_type = fnegate (dir.entry.d_type);
            dir.entry.d_protected = true;
         }

         cursor = memcpy_cursor (&len, cursor, sizeof (char));
         cursor = memcpy_cursor ((char *) &dir.entry.d_sectors, cursor, sizeof (double));
      
         cursor = memcpy_cursor (&len, cursor, sizeof (char));
         cursor = memcpy_cursor ((char *) &dir.entry.d_reclen, cursor, sizeof (double));
      
         dir.df->dsr->pab.RecordNumber++;
      
         r = &dir.entry;

      } else {
         r = NULL;
      }

      dylib.spinner_restore ();

   } else {
      r = NULL;
   }

   return r;
}
