/* remove.c
   This method removes a file or empty directory.
   change log:
   08/15/2023 initial version
   08/21/2023 replace use of fprintf with dylib.fputs
   11/21/2023 updated to use FILENAME_MAX
   11/23/2023 updated to use separate dsr
   03/01/2024 updated to use dylib
   01/10/2025 updated to use dylib.file_get_available
   01/20/2025 updated fputs to dylib
   06/03/2025 updated to remove files or empty directories
*/

#include <stdio.h>
#include <stdio_private.h>
#include <sys/stat.h>
#include <unistd_private.h>
#include <dsrl2_private.h>

int remove (const char *path) {
 
   struct stat statbuf;
   int r = stat (path, &statbuf);

   if (!r) {
      if (S_ISREG (statbuf.st_mode)) {
         r = remove_file (path);
      } else if (S_ISDIR (statbuf.st_mode)) {
         if (!dir_entry_count (path)) {
            r = dsrl2_rmdir (path);
         } else {
            r = 1;
         }
      }
   }

   return r;                                                        
}
