/* remove_file.c
   This method removes a file.
   change history
   06/03/2025 extracted from the rm command (rm.c)
*/

#include <stdio_private.h>
#include <dylib.h>

int remove_file (const char *path) {
   int r = UNDEFINED;
   char ti_path[FILENAME_MAX];
   dylib.generate_final_path (ti_path, (char *) path, false);       // generate the TI DSR path
   FILE *f = dylib.file_get_available (true);                       // get an available file handle for its associated vdp buffer
   if (f) {
      file_init_pab (f);                                            // initialize the pab
      f->dsr->pab.pName      = (unsigned char *) ti_path;           // set the name
      f->dsr->pab.NameLength = dylib.strlen (ti_path);              // set the name length
      f->dsr->pab.OpCode     = DSR_DELETE;                          // set the operation
      r = dylib.dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr); // perform the dsr operation
   }
   return r;
}
