/* sams_clone_file.c
   This method loads a binary file from disk into a named cache.
   change history
   07/12/2025 added header
*/

#include <sams_private.h>
#include <cache_private.h>
#include <stdio.h>
#include <string.h>

int sams_clone_file (const char *cache_name, unsigned char *sams_addr, const char *path) {
   FILE *f;
   int r = -1;

   f = fopen (path, "rb");
   if (f) {
      sams_find_cache (cache_name);
      r = fread (sams_addr, 1, 24 * 1024, f);
      fclose (f);
      sams_restore_proc_pages ();
   }
  
   return r;
}
