/* sams_expire_region.c
   This method expires a region.
   change history
   06/30/2025 initial version
   07/05/2025 SAMS paging algorithm changes
   07/08/2025 removed calls to enable and disable sams mapping
   07/09/2025 renaming named page count to named region count
   07/14/2025 added break to stop searching once the named cache is found
*/

#include <cache_private.h>
#include <sams_private.h>
#include <string.h>
#include <console.h>

int __attribute__ ((noinline)) sams_expire_region (int region) {
   int r = 1;

   int cache_info_region = (cache.sams.page_count - 16) / 6 - 1;          // 41 if this is a 1 MB SAMS card

   sams_cache_t * sams_cache = (sams_cache_t *) 0xa000;                   // generate a cache structure pointer
   sams_map_region (cache_info_region);                                   // set the sams map to the cache info region into memory

   sams_cache->age[region] = SAMS_MAX_CACHE_AGE;                          // age the cached item
   strcpy (sams_cache->filename[region], "_deleted");                     // clear its name

   r = 0;                                          

   sams_restore_proc_pages ();                                            // restore the last cache

   return r;
}
