/* sams_find_cache.c
   This method locates a named cache and maps the corresponding sams pages into memory.
   change history
   01/18/2025 migrated to this file from sams.c
              added saving of sams pages in use
   01/19/2025 updated to base the number of cached regions and the cached info region based on total number of pages
              enhanced caching by replacing aged entries with new when all entries are full
   01/25/2025 updated for sams_status_t
   06/25/2025 moved page count to cache
   07/05/2025 SAMS paging algorithm updates
   07/08/2025 removed calls to enable/disable mapping of pages
   07/09/2025 corrected page vs region
   07/14/2025 updated to age only unlocked caches (age > 0)
              removed duplicate statements setting the age
*/

#include <cache_private.h>
#include <sams_private.h>
#include <string.h>
#include <console.h>

int __attribute__ ((noinline)) sams_find_cache (const char *name) {
   int r = 1;                                                         // default the return to force the program loader to read the program from the filesystem

   if (cache.sams.page_count) {                                       // process this request if there are sams pages previously found
   
      int cache_info_region         = (cache.sams.page_count - 16) / 6 - 1;   // 41 if this is a 1 MB SAMS card
      int last_cache_storage_region = cache_info_region - 1;                 // 40 "

      sams_cache_t * sams_cache = (sams_cache_t *) 0xa000;            // generate a cache structure pointer
      sams_map_region (cache_info_region);                            // set the sams map to the cache info region into memory

      int region     = 0;                                             // page to load
      int oldest_age = 0;                                             // initialize the oldest aged item

      int i;
      for (i = 0; i < cache.sams.named_region_count; i++) {           // loop through all the cached items

         if (sams_cache->age[i]) {                                    // age caches that are not locked (age != 0)
            sams_cache->age[i]++;                                     // age the cached item
         }

         if (sams_cache->age[i] > SAMS_MAX_CACHE_AGE) {               // allow a maximum age. Doesn't much matter as long as its more than the max number of regions
            sams_cache->age[i] = SAMS_MAX_CACHE_AGE;
         }

         if (sams_cache->age[i] > oldest_age) {                       // collect the oldest item, that will be used if the cache is not found and the cache set is full
            oldest_age = sams_cache->age[i];
            region     = i;
         }
      }
    
      for (i = 0; i < cache.sams.named_region_count; i++) {           // locate this name in the cache

         if (!strcmp (name, sams_cache->filename[i])) {               // determine if this region is the right one
            region = i;
            r      = 0;                                               // indicate the item has been found
            break;
         }
      }

      if (r) {                                                                  // if the item was not found
         if (cache.sams.named_region_count <= last_cache_storage_region) {      // if there's still more slots then just store it
            region = cache.sams.named_region_count;                             // set the page
            cache.sams.named_region_count++;                                    // increment the count
         } 
         strcpy (sams_cache->filename[region], name);                    // save the cache name
      }

      cache.sams.region_in_use = region;                                 // save the region being used
      sams_cache->age[region]  = 1;
  
      sams_map_region (region);                                          // move to the prexistant image, the new image slot, or the image slot being replaced
   }

   return r;                                                           // return the result, which tells the caller whether the image must be loaded from disk or not
}
