/* sams_get_page_count.c
   This method determines the number of pages provided by the sams device, if present.
   change history
   01/18/2025 migrated to this file from sams.c
              moved the write position from a000 to a800 to minimize the chance that this destructive test will 
              overwrite a memory address already in use.
              added saving of the page count at 0xa800
   06/25/2025 updated to use SAMS_MAX_PAGES rather than hard coded 1024
   07/05/2025 updated to write page count to location that isn't able to be paged
   07/08/2025 removed enabling and disabling of sams mapping while counting memory
*/

#include <sams_private.h>
#include <vdp.h>

int __attribute__ ((noinline)) sams_get_page_count () {

   volatile int *v     = (volatile int *) 0xa800;
   volatile int *count = (volatile int *) 0x8320;
   *count = 0;

   int i;

   sams_map_page (16, 0xa000); // just set a page, in case there must be something mapped before enabling the map (kinda makes sense)
   sams_enable_map ();

   for (i = 16; i < SAMS_MAX_PAGES + 16; i++) {
      sams_map_page (i, 0xa000);
      *v = 0;
   }
   for (i = 16; i < SAMS_MAX_PAGES + 16; i++) {
      sams_map_page (i, 0xa000);
      if (!*v && i != 16) {
         *count = i - 15; // since we're starting counting pages at 16, and there will be wrap-around of pages 0-15 after the last real page
      }
      *v = 0x0001;
   }

   sams_disable_map ();

   return *count;
}
