/* sams_init.c
   This method initializes the sams device for use by the unix99 product.
   change history
   01/18/2025 migrated to this file from sams.c
   06/25/2025 removed calls to initialize data, as the initialization now occurs in the cache package
*/

#include <sams_private.h>
#include <vdp.h>

void __attribute__ ((noinline)) sams_init () {

   int sams_page_count = sams_get_page_count ();

   if (sams_page_count) {

      #ifdef SAMS_PERFORM_TEST
         sams_test_memory ();
      #else
         #define SAMS "SAMS"
         vdpmemcpy (0x0020, (unsigned char *) SAMS, sizeof (SAMS));
      #endif

      sams_map_region (0);
      sams_enable_map ();
   }
}
