/* sams_lock_named.c
   This method locks a cache so it cannot be removed. This is done simply by setting it's age to zero.
   change history
   07/14/2025 initial version
*/

#include <cache_private.h>
#include <sams_private.h>
#include <string.h>
#include <console.h>

int __attribute__ ((noinline)) sams_lock_cache (const char *name) {
   int r = 1;

   int cache_info_region = (cache.sams.page_count - 16) / 6 - 1;          // 41 if this is a 1 MB SAMS card

   sams_cache_t * sams_cache = (sams_cache_t *) 0xa000;                   // generate a cache structure pointer
   sams_map_region (cache_info_region);                                   // set the sams map to the cache info region into memory

   for (int i = 0; i < cache.sams.named_region_count; i++) {              // locate all occurances of this series of caches
      if (!strcmp (name, sams_cache->filename[i])) {
         sams_cache->age[i] = SAMS_LOCKED_AGE;                            // age the cached item
         r                  = 0;                                          // indicate it was found
         break;
      }
   }

   sams_restore_proc_pages ();                                            // restore the last cache

   return r;
}
