/* sams_map_region.c
   This method maps a page region into the upper memory addresses and always sets the
   lower memory to pages 0 and 1.
   change history
   01/18/2025 migrated to this file from sams.c
   07/05/2025 SAMS paging algorithm changes
*/

#include <sams_private.h>

void __attribute__ ((noinline)) sams_map_region (int r) {

   const int page_first = 16 + r * 6;
   unsigned int addr = 0xa000;
   for (int j = page_first; j < page_first + 6; j++) {
      sams_map_page (j, addr);
      addr += 0x1000;
   }
   sams_map_page (0, 0x2000);
   sams_map_page (1, 0x3000);
}
