/* sams_restore_proc_pages.c
   This method remaps a processes pages, which may have been altered.
   change history
   07/12/2025 initial version
   07/14/2025 corrected region_in_use
*/

#include <sams_private.h>
#include <cache_private.h>

void sams_restore_proc_pages () {
   unsigned int addr = 0xa000;
   for (int i = 0; i < 6; i++) {
      sams_map_page (cache.sams.proc_page[i], addr);
      addr += 0x1000;
   }
   cache.sams.region_in_use = (cache.sams.proc_page[0] - 16) / 6;
}
