/* sams_set_region_age.c
   This method sets a region age.
   change history
   07/14/2025 initial version
*/

#include <cache_private.h>
#include <sams_private.h>
#include <string.h>
#include <console.h>

int __attribute__ ((noinline)) sams_set_region_age (int region, int age) {
   int r = 1;

   if (cache.sams.page_count) {
      int cache_info_region = (cache.sams.page_count - 16) / 6 - 1;          // 41 if this is a 1 MB SAMS card

      sams_cache_t * sams_cache = (sams_cache_t *) 0xa000;                   // generate a cache structure pointer
      sams_map_region (cache_info_region);                                   // set the sams map to the cache info region into memory
   
      sams_cache->age[region] = age;                                         // age the cached item

      r = 0;

      sams_restore_proc_pages ();                                            // restore the last cache
   }

   return r;
}
