/* sams_test_memory.c
   This method tests a single word on each memory page.
   change history
   01/18/2025 migrated to this file from sams.c
*/

#include <sams_private.h>
#include <vdp.h>

void __attribute__ ((noinline)) sams_test_memory () {
   #define TEST_NAME "SAMS MEMORY TEST..."
   vdpmemcpy (0x0020, (unsigned char *) TEST_NAME, sizeof (TEST_NAME));
   int * v;
   v = (int *) 0xa000;
   int i;

   sams_enable_map ();

   for (i = 0; i < 42; i++) {
      sams_disable_map ();
      sams_map_region (i);
      sams_enable_map ();
      *v = i;
   }

   for (i = 0; i < 42; i++) {
      sams_disable_map ();
      sams_map_region (i);
      sams_enable_map ();
      if (*v != i) {
         #define FAIL "FAIL"
         vdpmemcpy (0x0033, (unsigned char *) FAIL, sizeof (FAIL));
         while (1);
      }
   }

   sams_disable_map ();

   #define PASS "PASS"
   vdpmemcpy (0x0033, (unsigned char *) PASS, sizeof (PASS));
}
