/* sequencer_add.c
   This method adds a callable function to the sequencer.
   06/23/2023 initial version
   02/24/2024 modified to use cache
*/

#include <cache_private.h>
#include <sequencer_private.h>

int sequencer_add (void (*function) (void)) {
   int r;
   if (cache.sequences_info.count < SEQUENCES_MAX) {
      cache.sequences_info.method[cache.sequences_info.count] = function;
      cache.sequences_info.count++;
      r = 0;
   } else {
      r = -1;
   }
   return r;
}
