/* sequencer_remove.c
   This method removes a callable function from the sequencer.
   06/23/2023 initial version
   11/03/2023 moved allocations outside of the for loops
   02/24/2024 modified to use cache
*/

#include <cache_private.h>
#include <sequencer_private.h>

int sequencer_remove (void (*function) (void)) {

   int r = -1;
   int i, j;

   // loop through the all the functions in the sequencer
   for (i = 0; i < cache.sequences_info.count; i++) {

      // determine if this is the function to be removed
      if (cache.sequences_info.method[i] == function) {

         // this is the function to be removed: move the subsequent functions one position earlier
         for (j = i; j < cache.sequences_info.count - 1; j++) {
            cache.sequences_info.method[j] = cache.sequences_info.method[j + 1];
         }

         // reduce the count
         cache.sequences_info.count--;

         // set return to success
         r = 0;

         // break out of the loop
         break;
      }
   }

   // return the result
   return r;
}
