/* sequencer_update.c
   This method processes each added method calling each.
   06/23/2023 initial version
   11/03/2023 moved vdp int polling from soundqueue to here
   02/24/2024 modified to use cache
*/

#include <cache_private.h>
#include <sequencer_private.h>
#include <vdp.h>

void sequencer_update () {
   int i;

   for (i = 0; i < cache.sequences_info.throttle; i++) {
      VDP_INT_POLL;
   }

   for (i = cache.sequences_info.count - 1; i >= 0; i--) {
      cache.sequences_info.method[i] ();
   }

   VDP_INT_POLL;
}
