/* setlogin.c
   This method sets the user id.
   change log:
   11/10/2023 initial version
   11/12/2023 updated to use get_passwd_file_path
   11/13/2023 added reading of the home directory
   11/15/2023 added reading of the shell
              removed cr/lf when reading the line
   11/16/2023 improved documentation
   11/21/2023 updated to set cwd based on home directory
   11/25/2023 updated to use the accts package
   12/10/2023 removed reference to string_ext.h
   02/24/2024 broad changes for cache and dylib
   03/01/2024 updated to use dylib
*/

#include <stdio.h>
#include <unistd.h>
#include <unistd_private.h>
#include <cache_private.h>
#include <string.h>
#include <accts_private.h>
#include <dylib.h>

int setlogin (const char *name) {
   int r = -1;
   if (cache.login.user_id == 0) {                            // ensure user is root

      accts_t accts;

      accts_init (&accts);
      r = accts_read (&accts);
 
      if (!r) {
         char s[32];
         int v;
         r = accts_get_value (&accts, name, PASSWD_LOGIN, s, &v);
         dylib.strcpy (cache.login.name, s);
         if (!r) {
            r |= accts_get_value (&accts, name, PASSWD_UID, s, &v);
            cache.login.user_id = v;
            r |= accts_get_value (&accts, name, PASSWD_HOMEDIR, s, &v);
            dylib.strcpy (cache.login.home_dir, s);
            r |= accts_get_value (&accts, name, PASSWD_SHELL, s, &v);
            dylib.strcpy (cache.login.shell, s);
            chdir (cache.login.home_dir); 
            cache.login.session_id = 1; 
         }
         accts_free (&accts);
      }
   }
   return r;                                                   // return the result
}
