/* signal.c
   This method sets a signal handler.
   change history
   06/05/2025 initial version
*/

#include <signal.h>
#include <stdio.h>

#include <cache_private.h>

sig_t signal (int sig, sig_t func) {
   switch (sig) {
      case SIGHUP:
         cache.signal_handler.sighup  = func;
         break;
      case SIGINT:
         cache.signal_handler.sigint  = func;
         break;
      case SIGKILL:
         cache.signal_handler.sigkill = func;
         break;
      case SIGUSR1:
         cache.signal_handler.sigusr1 = func;
         break;
      case SIGUSR2:
         cache.signal_handler.sigusr2 = func;
         break;
      default:
         break;
   }

   return NULL;
}
