/* skip_whitespace.c
   This method returns a pointer to the next non-white space value in a string, or null if the end of string is reached.
   change log:
   06/23/2023 initial version
   12/10/2023 removed reference to string_ext.h
*/

#include <string.h>
#include <constants.h>
#include <ctype.h>

char *skip_whitespace (const char *str) {
   char *s = (char *) str;
   while ( isspace (*s) && (*s != NULL_CHAR) ) s++;
   return s;
}
