/* soundqueue_load.c
   This method adds a sound to the soundqueue package that can be played at a later time.
   06/23/2023 initial version
   11/03/2023 added auto-initialization of the sound package
*/

#include <constants.h>
#include <soundqueue.h>
#include <soundqueue_private.h>

int soundqueue_load (char *saddr, int len, int preemption_rule) {
   int r;
   soundqueue_init ();
   if (soundqueue_info.count < SOUND_ENTRIES_NUM) {
      soundqueue_info.entry[soundqueue_info.count].saddr           = saddr;
      soundqueue_info.entry[soundqueue_info.count].len             = len;
      soundqueue_info.entry[soundqueue_info.count].pos             = len;
      soundqueue_info.entry[soundqueue_info.count].preemption_rule = preemption_rule;
      soundqueue_info.entry[soundqueue_info.count].in_use          = true;
      r = soundqueue_info.count;
      soundqueue_info.count++;
   } else {
      r = UNDEFINED;
   }
   return r;
}
