/* soundqueue_play.c
   This method plays a sound that has been previously loaded.
   06/23/2023 initial version
   10/25/2025 forced initial update to better sync sound. Previous method worked but had a lazy and delayed start
*/

#include <constants.h>
#include <soundqueue.h>
#include <soundqueue_private.h>

void soundqueue_play (int h) {
   if (soundqueue_info.current != UNDEFINED) {
      if (soundqueue_info.entry[soundqueue_info.current].preemption_rule == SOUNDQUEUE_PREEMPTION_RULE_ABORT) {
         soundqueue_info.entry[soundqueue_info.current].pos = soundqueue_info.entry[soundqueue_info.current].len;
      }
   }

   // set this as the current sound
   soundqueue_info.entry[h].pos = 0;
   soundqueue_info.current      = h;

   soundqueue_play_update ();
}
