/* sounds_get_seq_ominous_dundundun.c
   This method returns the sound sequence for the ominous dun-dun-dun.
   change log:
   06/23/2023 initial version
   06/11/2023 removed include for sound.h
*/

#include <sounds.h>
#include <soundqueue_private.h>

void sounds_get_seq_ominous_dundundun (char **p, int *len) {
/* 
   Dun Dun Dun notes

   Note TI_SFreq   Note_Freq  base10_val  base16_tone_val
   ---- --------   ---------  ----------  ---------------
   Eb3  111860.8 / 155.56   = 719       = 0x2CF
   C3   111860.8 / 130.81   = 855       = 0x357
   F3#  111860.8 / 185.00   = 605       = 0x25D
   The base16_tone_val is the freq value to be used in the sound command
   The value 111,860.8 is the TI99's 3.58 MHz clock signal divided by 32
*/
   #define DUN_DUN_DUN_FREQ 0x0a
   static const char ominous_sound[] = {
      0x03, TONE1_VOL | 0x00, TONE1_FREQ | 0x0f, 0x2c, DUN_DUN_DUN_FREQ,
      0x03, TONE1_VOL | 0x00, TONE1_FREQ | 0x07, 0x35, DUN_DUN_DUN_FREQ,
      0x03, TONE1_VOL | 0x00, TONE1_FREQ | 0x0d, 0x25, DUN_DUN_DUN_FREQ * 2,
      0x01, TONE1_VOL | 0x01, DUN_DUN_DUN_FREQ,
      0x01, TONE1_VOL | 0x03, DUN_DUN_DUN_FREQ,
      0x01, TONE1_VOL | 0x05, DUN_DUN_DUN_FREQ,
      0x01, TONE1_VOL | 0x0f, 0x00
   };
   *p   = (char *) ominous_sound;
   *len = sizeof (ominous_sound);
}
