/* sounds_get_seq_supermario.c
   This method returns the sound sequence for the super mario theme song.
   change log:
   06/23/2023 initial version
*/

#include <sounds.h>

void sounds_get_seq_supermario (char **p, int *len) {
   static const char super_mario_sound[] = {
      0x09, 0x89, 0x2f, 0x90, 0xa9, 0x0a, 0xb0, 0xce, 0x12, 0xd0, 0x08, 
      0x03, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x03, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa9, 0x2f, 0xb0, 0xd0, 0x08, 
      0x05, 0x89, 0x0a, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xad, 0x11, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x01, 0x9f, 0x08, 
      0x04, 0x8a, 0x23, 0x90, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa3, 0x15, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa6, 0x2a, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x87, 0x35, 0x90, 0xa3, 0x15, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8f, 0x0e, 0x90, 0xa3, 0x19, 0xb0, 0xcc, 0x25, 0xd0, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x07, 0x86, 0x2a, 0x90, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x05, 0x89, 0x0a, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x09, 0x8f, 0x07, 0x90, 0xa5, 0x0d, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xac, 0x17, 0xb0, 0xc0, 0x0a, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8c, 0x1f, 0x90, 0xa5, 0x0d, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x09, 0x84, 0x1c, 0x90, 0xae, 0x0b, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa3, 0x15, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa6, 0x2a, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x87, 0x35, 0x90, 0xa3, 0x15, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8f, 0x0e, 0x90, 0xa3, 0x19, 0xb0, 0xcc, 0x25, 0xd0, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x07, 0x86, 0x2a, 0x90, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x05, 0x89, 0x0a, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x09, 0x8f, 0x07, 0x90, 0xa5, 0x0d, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xac, 0x17, 0xb0, 0xc0, 0x0a, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8c, 0x1f, 0x90, 0xa5, 0x0d, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x09, 0x84, 0x1c, 0x90, 0xae, 0x0b, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x87, 0x35, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x06, 0x89, 0x0a, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x07, 0x83, 0x0b, 0x90, 0xa7, 0x09, 0xb0, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x06, 0x82, 0x0e, 0x90, 0xa3, 0x0b, 0xb0, 0x08, 
      0x04, 0x8b, 0x1a, 0x90, 0xbf, 0x08, 
      0x06, 0x85, 0x0d, 0x90, 0xa9, 0x0a, 0xb0, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x06, 0x8d, 0x10, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa0, 0x14, 0xb0, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x90, 0xbf, 0xdf, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa0, 0x28, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xae, 0x12, 0xb0, 0xdf, 0x08, 
      0x04, 0x87, 0x35, 0x90, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x06, 0x89, 0x0a, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x09, 0x86, 0x2a, 0x90, 0xa3, 0x0b, 0xb0, 0xc7, 0x09, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x06, 0x82, 0x0e, 0x90, 0xa3, 0x0b, 0xb0, 0x08, 
      0x04, 0x8a, 0x23, 0x90, 0xbf, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x06, 0x8a, 0x06, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x02, 0x90, 0xb0, 0x08, 
      0x02, 0x90, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x03, 0x8a, 0x23, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x87, 0x35, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x02, 0xb0, 0xd0, 0x08, 
      0x09, 0x83, 0x0b, 0x90, 0xaa, 0x23, 0xb0, 0xc7, 0x09, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x06, 0x82, 0x0e, 0x90, 0xa3, 0x0b, 0xb0, 0x08, 
      0x04, 0x8b, 0x1a, 0x90, 0xbf, 0x08, 
      0x06, 0x85, 0x0d, 0x90, 0xa9, 0x0a, 0xb0, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x06, 0x8d, 0x10, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa0, 0x14, 0xb0, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x90, 0xbf, 0xdf, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa0, 0x28, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xae, 0x12, 0xb0, 0xdf, 0x08, 
      0x04, 0x87, 0x35, 0x90, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8a, 0x21, 0x90, 0xad, 0x10, 0xb0, 0xc3, 0x0b, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8f, 0x1d, 0x90, 0xae, 0x0b, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x8a, 0x23, 0x90, 0x08, 
      0x01, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x87, 0x35, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x01, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x06, 0x89, 0x0a, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x09, 0x83, 0x0b, 0x90, 0xaa, 0x23, 0xb0, 0xc7, 0x09, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x06, 0x82, 0x0e, 0x90, 0xa3, 0x0b, 0xb0, 0x08, 
      0x04, 0x8b, 0x1a, 0x90, 0xbf, 0x08, 
      0x06, 0x85, 0x0d, 0x90, 0xa9, 0x0a, 0xb0, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x06, 0x8d, 0x10, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa0, 0x14, 0xb0, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x90, 0xbf, 0xdf, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa0, 0x28, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xae, 0x12, 0xb0, 0xdf, 0x08, 
      0x04, 0x87, 0x35, 0x90, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x06, 0x89, 0x0a, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x09, 0x86, 0x2a, 0x90, 0xa3, 0x0b, 0xb0, 0xc7, 0x09, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x06, 0x82, 0x0e, 0x90, 0xa3, 0x0b, 0xb0, 0x08, 
      0x04, 0x8a, 0x23, 0x90, 0xbf, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x06, 0x8a, 0x06, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x02, 0x90, 0xb0, 0x08, 
      0x02, 0x90, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x03, 0x8a, 0x23, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x87, 0x35, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x02, 0xb0, 0xd0, 0x08, 
      0x09, 0x83, 0x0b, 0x90, 0xaa, 0x23, 0xb0, 0xc7, 0x09, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x06, 0x82, 0x0e, 0x90, 0xa3, 0x0b, 0xb0, 0x08, 
      0x04, 0x8b, 0x1a, 0x90, 0xbf, 0x08, 
      0x06, 0x85, 0x0d, 0x90, 0xa9, 0x0a, 0xb0, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x06, 0x8d, 0x10, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa0, 0x14, 0xb0, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x90, 0xbf, 0xdf, 0x08, 
      0x06, 0x8e, 0x0f, 0x90, 0xa3, 0x15, 0xb0, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa0, 0x28, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x07, 0x8e, 0x0b, 0x90, 0xae, 0x12, 0xb0, 0xdf, 0x08, 
      0x04, 0x87, 0x35, 0x90, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8a, 0x21, 0x90, 0xad, 0x10, 0xb0, 0xc3, 0x0b, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8f, 0x1d, 0x90, 0xae, 0x0b, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x8a, 0x23, 0x90, 0x08, 
      0x01, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x87, 0x35, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x85, 0x43, 0x90, 0xad, 0x10, 0xb0, 0xc5, 0x0d, 0xd0, 0x08, 
      0x03, 0x9f, 0xb0, 0xd0, 0x08, 
      0x02, 0xbf, 0xdf, 0x08, 
      0x05, 0x8f, 0x2c, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x02, 0xb0, 0xd0, 0x08, 
      0x09, 0x8a, 0x21, 0x90, 0xaf, 0x0e, 0xb0, 0xce, 0x0b, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x89, 0x0a, 0x90, 0xaa, 0x23, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa3, 0x15, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xa7, 0x35, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x07, 0x8c, 0x17, 0x90, 0xad, 0x11, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x03, 0x85, 0x47, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x85, 0x43, 0x90, 0xad, 0x10, 0xb0, 0xc5, 0x0d, 0xd0, 0x08, 
      0x03, 0x9f, 0xb0, 0xd0, 0x08, 
      0x02, 0xbf, 0xdf, 0x08, 
      0x05, 0x8f, 0x2c, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x02, 0xb0, 0xd0, 0x08, 
      0x09, 0x8a, 0x21, 0x90, 0xaf, 0x0e, 0xb0, 0xce, 0x0b, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x89, 0x0a, 0x90, 0xaa, 0x23, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x87, 0x35, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x01, 0x9f, 0x08, 
      0x03, 0x85, 0x47, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x85, 0x43, 0x90, 0xad, 0x10, 0xb0, 0xc5, 0x0d, 0xd0, 0x08, 
      0x03, 0x9f, 0xb0, 0xd0, 0x08, 
      0x02, 0xbf, 0xdf, 0x08, 
      0x05, 0x8f, 0x2c, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x02, 0xb0, 0xd0, 0x08, 
      0x09, 0x8a, 0x21, 0x90, 0xaf, 0x0e, 0xb0, 0xce, 0x0b, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x89, 0x0a, 0x90, 0xaa, 0x23, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa3, 0x15, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xa7, 0x35, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x07, 0x8c, 0x17, 0x90, 0xad, 0x11, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x03, 0x85, 0x47, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x89, 0x2f, 0x90, 0xa9, 0x0a, 0xb0, 0xce, 0x12, 0xd0, 0x08, 
      0x03, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x03, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa9, 0x2f, 0xb0, 0xd0, 0x08, 
      0x05, 0x89, 0x0a, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xad, 0x11, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x01, 0x9f, 0x08, 
      0x04, 0x8a, 0x23, 0x90, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa3, 0x15, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa6, 0x2a, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x87, 0x35, 0x90, 0xa3, 0x15, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8f, 0x0e, 0x90, 0xa3, 0x19, 0xb0, 0xcc, 0x25, 0xd0, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x07, 0x86, 0x2a, 0x90, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x05, 0x89, 0x0a, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x09, 0x8f, 0x07, 0x90, 0xa5, 0x0d, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xac, 0x17, 0xb0, 0xc0, 0x0a, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8c, 0x1f, 0x90, 0xa5, 0x0d, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x09, 0x84, 0x1c, 0x90, 0xae, 0x0b, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa3, 0x15, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa6, 0x2a, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x87, 0x35, 0x90, 0xa3, 0x15, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8f, 0x0e, 0x90, 0xa3, 0x19, 0xb0, 0xcc, 0x25, 0xd0, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc0, 0x28, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x07, 0x86, 0x2a, 0x90, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x05, 0x89, 0x0a, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x09, 0x8f, 0x07, 0x90, 0xa5, 0x0d, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xac, 0x17, 0xb0, 0xc0, 0x0a, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa3, 0x15, 0xb0, 0xce, 0x08, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8c, 0x1f, 0x90, 0xa5, 0x0d, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x09, 0x84, 0x1c, 0x90, 0xae, 0x0b, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xac, 0x17, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x87, 0x35, 0x90, 0xa5, 0x0d, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x05, 0x8e, 0x0f, 0x90, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x09, 0x83, 0x15, 0x90, 0xad, 0x11, 0xb0, 0xcc, 0x25, 0xd0, 0x08, 
      0x05, 0x8a, 0x23, 0x90, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8d, 0x10, 0x90, 0xab, 0x1a, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xa0, 0x28, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x04, 0x85, 0x0d, 0x90, 0xb0, 0x08, 
      0x07, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xb0, 0xdf, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xa9, 0x2f, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x07, 0x8f, 0x07, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x02, 0x90, 0xb0, 0x08, 
      0x03, 0xc0, 0x28, 0xd0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x05, 0x90, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x06, 0x8e, 0x0b, 0x90, 0xae, 0x08, 0xb0, 0x08, 
      0x03, 0xc4, 0x1c, 0xd0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x07, 0x82, 0x0e, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x09, 0x85, 0x0d, 0x90, 0xa9, 0x0a, 0xb0, 0xca, 0x23, 0xd0, 0x08, 
      0x07, 0x8e, 0x0f, 0x90, 0xa5, 0x0d, 0xb0, 0xdf, 0x08, 
      0x03, 0x9f, 0xbf, 0xd0, 0x08, 
      0x05, 0x90, 0xa0, 0x14, 0xb0, 0xdf, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa3, 0x15, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x03, 0x90, 0xbf, 0xdf, 0x08, 
      0x03, 0x8a, 0x23, 0x90, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x87, 0x35, 0x90, 0xa5, 0x0d, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x05, 0x8e, 0x0f, 0x90, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x09, 0x83, 0x15, 0x90, 0xad, 0x11, 0xb0, 0xcc, 0x25, 0xd0, 0x08, 
      0x05, 0x8a, 0x23, 0x90, 0xbf, 0xdf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x8d, 0x10, 0x90, 0xab, 0x1a, 0xb0, 0xc3, 0x15, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xa0, 0x28, 0xb0, 0xc0, 0x14, 0xd0, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x04, 0x85, 0x0d, 0x90, 0xb0, 0x08, 
      0x07, 0x8e, 0x0f, 0x90, 0xab, 0x1a, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xb0, 0xdf, 0x08, 
      0x04, 0x80, 0x28, 0x90, 0xbf, 0x08, 
      0x01, 0x9f, 0x08, 
      0x09, 0x82, 0x0e, 0x90, 0xaa, 0x23, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x07, 0x85, 0x0d, 0x90, 0xa0, 0x0a, 0xb0, 0xdf, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x02, 0x90, 0xb0, 0x08, 
      0x03, 0xca, 0x23, 0xd0, 0x08, 
      0x02, 0x9f, 0xbf, 0x08, 
      0x03, 0x90, 0xb0, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8c, 0x1f, 0x90, 0xa2, 0x0e, 0xb0, 0xc9, 0x0a, 0xd0, 0x08, 
      0x03, 0x9f, 0xbf, 0xdf, 0x08, 
      0x09, 0x8e, 0x0f, 0x90, 0xa4, 0x1c, 0xb0, 0xce, 0x0b, 0xd0, 0x08, 
      0x09, 0x8b, 0x1a, 0x90, 0xa5, 0x0d, 0xb0, 0xcd, 0x11, 0xd0, 0x08, 
      0x05, 0x83, 0x15, 0x90, 0xbf, 0xdf, 0x08, 
      0x03, 0x8a, 0x23, 0x90, 0x08, 
      0x03, 0x83, 0x15, 0x90, 0x08, 
      0x06, 0x87, 0x35, 0x90, 0xab, 0x1a, 0xb0, 0x08, 
      0x02, 0x9f, 0xbf, 0x00
   };
   *p   = (char *) super_mario_sound;
   *len = sizeof (super_mario_sound);
}
