/* speechqueue_init.c
   This method initializes the speechqueue package.
   change log:
   06/23/2023 initial version
   10/21/2023 added auto-initialization
   10/22/2023 updated to use public sequencer methods
   01/24/2025 made is_initialized non-static
*/

#include <speech.h>
#include <speechqueue_private.h>
#include <sequencer.h>
#include <stdbool.h>

bool speech_queue_is_initialized = false;
#define SPEECH_QUEUE_LENGTH 32
int speech_queue[SPEECH_QUEUE_LENGTH];
int speech_queue_read_pos;
int speech_queue_write_pos;

void speechqueue_init () {
   if (!speech_queue_is_initialized) {

      for (int i = 0; i < SPEECH_QUEUE_LENGTH; i++) {
         speech_queue[i] = 0;
      }
      speech_queue_read_pos  = 0;
      speech_queue_write_pos = 0;
   
      if (detect_speech ()) {
         // add the player to the seqeuncer
         sequencer_add (speechqueue_play);
      }
      
      speech_queue_is_initialized = true;
   }
}
