/* speechqueue_play.c
   This method plays the next speech word if the queue is found empty.
   change log:
   06/23/2023 initial version
   10/21/2023 added auto-initialization
*/

#include <speech.h>
#include <speechqueue_private.h>

void speechqueue_play () {

   speechqueue_init ();

   if (speech_queue[speech_queue_read_pos] != 0) {
      SPEECH_BYTE_BOX = SPCH_STATUS_TALK;
      READ_WITH_DELAY ();
      if (!(SPEECH_BYTE_BOX & SPCH_STATUS_TALK)) {
         say_vocab (speech_queue[speech_queue_read_pos]);
         speech_queue[speech_queue_read_pos] = 0;
         speech_queue_read_pos++;
         if (speech_queue_read_pos >= SPEECH_QUEUE_LENGTH) speech_queue_read_pos = 0;
         delay_asm_42();
         delay_asm_12();
      }
   }
}
