/* spinner.c
   This file contains the methods for spinner
   change log:
   02/24/2024 initial version
*/

#include <spinner_private.h>
#include <cache_private.h>
#include <console.h>

void spinner_read () {
   cache.spinner_state.underchar[0] = console_read_raw_char (0, 0);
}

void spinner_write () {
   static const char spinner[] = {'|', '/', '-', '\\'};
   cache.spinner_state.index++;
   if (cache.spinner_state.index > 3) cache.spinner_state.index = 0;
   char * s = (char *) spinner;
   s += cache.spinner_state.index;
   console_write_raw (0, 0, s, 1);
}

void spinner_restore () {
   console_write_raw (0, 0, (char *) cache.spinner_state.underchar, 1);
}
