/* sram_get_size.c
   This method returns the size of available sram memory.
   change history
   04/10/2025 initial version
*/

int sram_get_size () {

   int *v;                                                     // read/write address
   int i;                                                      // counter
   int have_expansion;
   int size[] = {256, 1024};

   v = (int *) 0x804A;                                         // write to 0x8?4A incrementing values from 0 to 3
   for (i = 0; i < 4; i++) {
      *v = i;
      v += 0x80;
   }

   v = (int *) 0x804A;                                         // test the values written previously
   have_expansion = 1;
   for (i = 0; i < 4; i++) {
      have_expansion = have_expansion && (*v == i);
      v += 0x80;
   }

   return size[have_expansion];
}
