/* start_ea5.c
   This method handles all the method-based startup for a C program in Unix. Note that this method likely bares
   little resemblence to the SYS V, BSD or Linux startup method, although it ultimately results in the same effect.
   change log:
   06/23/2023 initial version
   08/05/2023 added cwd support
   08/06/2023 added start method specifically for EA5 programs that can support more functionality
   08/14/2023 moved reading and setting of cwd before setting piped/redirected standard files
   08/15/2023 modified to use trusted chdir
   09/08/2023 updated references for UNIX99 INITD
   10/21/2023 updated for auto-initialization of speechqueue
   10/21/2023 modified to address malloc auto-initialization
   10/21/2023 removed memory library
   10/22/2023 removed reference to plugin chdir
              removed call to unistd_init
   11/03/2023 updated to call readcwd when cwd read from the proc file is empty
              removed soundqueue_init call since soundqueue is now auto-initializing
   11/21/2023 removed setting cwd
              updated to use FILENAME_MAX
   02/10/2024 removed initializing the cache as the cache being initialized is a precondition of running an ea5 program
   02/18/2024 added initialization of the dylib
   02/25/2024 updated to call dylib_ea5_link (name change)
              added setting of cache._start
              modified to call library methods in dylib
   04/08/2024 removed setting of cache._start
   12/25/2024 removed unnecessary comments
   01/06/2025 updated filename definitions and removed pointers for std files
   01/17/2025 added atexit call to close files at program termination
   01/20/2025 updated to call dylib.file_open_std_files
   01/24/2025 removed items initialized in rom
   02/16/2025 added call to clear application-specific gpu methods from vdp ram
   04/21/2025 added centering of mouse when present
   04/24/2025 removed mouse centering
   06/05/2025 added resetting of the signal handlers
   06/15/2025 updated exit references
*/

#include <string.h>
#include <stdlib.h>
#include <cache_private.h>
#include <stdlib_private.h>
#include <stdio_private.h>
#include <console_private.h>
#include <sequencer_private.h>
#include <unistd.h>
#include <unistd_private.h>
#include <dirent_private.h>
#include <dylib.h>
#include <vdp.h>
#include <conversion.h>
// #include <kernel_private.h>
#include <signal_private.h>

int main (int argc, char *argv[]);

int start_ea5 () {

   // perform the dynamic library link for an EA5
   dylib_ea5_link ();

   // initialize the atexit data
   dylib.atexit_init ();

   // initialize the sequencer -- this will address VDP polling, sound queue playing, speech queue playing, possibly sprite motion
   dylib.sequencer_init ();

   // add closing of files to program exit
   dylib.atexit (dylib.file_atexit);

   // initialize the default signal handlers
   signal_cache_init ();

   // clear any application-oriented gpu methods
   gpu_method_purge ();

   // this is an ea5

   char fstdin[FILENAME_MAX];
   char fstdout[FILENAME_MAX];
   char fstderr[FILENAME_MAX];
   char p[7][32];           // storage for argv[]
   int argc;                // argument count
   int i;

   // map the args to an array
   char *argv[10];
   for (i = 0; i < 7; i++) argv[i] = p[i];

   // capture the redirected files, if any, and the arguments
   // note that the argc may be zero and will occur if the ea5 was started by another program other than the UNIX99 INITD
   proc_get_ea5_params (fstdin, fstdout, fstderr, &argc, argv);

   // open the standard files, possibly with redirection
   file_open_std_files (fstdin, fstdout, fstderr);

   // finally call main
   main (argc, argv);

   // call for exit
   exit (0);

   return 0;
}
