/* strcasecmp.c
   This method compares strings ignoring case.
   change log:
   06/23/2023 initial version
   12/10/2023 removed reference to string_ext.h
*/

#include <ctype.h>
#include <string.h>

int strcasecmp (const char *a, const char *b) {
   while(*a) {                              // walk through all of a
      if (tolower (*a) != tolower (*b)) {   // compare the character at a and b on a case-insensitive basis. Note that b might
                                            // reach a null character in this process, which would also cause the break.
         break;
      }
      a++;                                  // increment a and b positions
      b++;
   }
   return tolower (*(const unsigned char*)a) - tolower (*(const unsigned char*)b); // finally return the result
}
