/* strcasestr.c
   This method finds an occurance of the needle in the haystack without regard to case.
   change log:
   06/23/2023 initial version
*/

#include <ctype.h>
#include <stdbool.h>
#include <stdio.h>

char *strcasestr (const char *haystack, const char *needle) {
   char *hp = (char *) haystack;
   char *htp;
   char *np;
   bool match = false;
   while (*hp != 0x00) {
      np  = (char *) needle;
      htp = hp;
      match = true;
      while ((*np != 0x00) && (htp != 0x00)) {
         if (toupper (*np) != toupper (*htp)) {
            match = false;
            break;
         }
         np++;
         htp++;
      }
      if (match) {
         break;
      }
      hp++;
   }
   if (!match) {
      hp = NULL;
   }
   return hp;
}
