/* strftime.c
   This method converts a tm struct into the specified ascii format.
   change log
   06/13/2025 initial version
   06/17/2025 added processing for %j, %w, and %u
*/

#include <time.h>
#include <time_private.h>
#include <dylib.h>

int strftime (char *restrict s, int maxsize, const char *restrict format, const struct tm *restrict timeptr) {

   // weekday and month constants
   const char *weekday_full[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
   const char *weekday_abbreviated[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
   const char *month_full[] = {"January", "February", "March", "April", "May", "June", "July", "August", "Septempber", "October", "November", "December"};
   const char *month_abbreviated[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

   int r = 1;

   bool in_escape = false;
   char *p = (char *) format;
   char st[80];
   int it;
   dylib.strcpy (s, "");           // initialize the output
   if (*p == '+') {              // must start with +
      p++;                       // advance the pointer

      // loop until null terminator
      while (*p != 0x00) {
         if (in_escape) {
            // process escape sequence
            switch (*p) {
               case 'Y':
                  sprintf (st, "%4d", timeptr->tm_year);
                  dylib.strcat (s, st);
                  break;
               case 'y':
                  sprintf (st, "%02d", timeptr->tm_year - 2000);
                  dylib.strcat (s, st);
                  break;
               case 'm':
                  sprintf (st, "%02d", timeptr->tm_mon);
                  dylib.strcat (s, st);
                  break;
               case 'd':
                  sprintf (st, "%2d", timeptr->tm_mday);
                  dylib.strcat (s, st);
                  break;
               case 'H':
                  sprintf (st, "%02d", timeptr->tm_hour);
                  dylib.strcat (s, st);
                  break;
               case 'M':
                  sprintf (st, "%02d", timeptr->tm_min);
                  dylib.strcat (s, st);
                  break;
               case 'S':
                  sprintf (st, "%02d", timeptr->tm_sec);
                  dylib.strcat (s, st);
                  break;
               case 'A':
                  dylib.strcat (s, weekday_full[timeptr->tm_wday]);
                  break;
               case 'a':
                  dylib.strcat (s, weekday_abbreviated[timeptr->tm_wday]);
                  break;
               case 'B':
                  dylib.strcat (s, month_full[timeptr->tm_mon]);
                  break;
               case 'b':
                  dylib.strcat (s, month_abbreviated[timeptr->tm_mon]);
                  break;
               case 'p':
                  if (timeptr->tm_hour >= 12) {
                     dylib.strcat (s, "PM");
                  } else {
                     dylib.strcat (s, "AM");
                  }
                  break;
               case 'I':
                  it = timeptr->tm_hour;
                  if (it > 12) {
                     it = it - 12;
                  }
                  sprintf (st, "%02d", it);
                  dylib.strcat (s, st);
                  break;
               case 'T':
                  sprintf (st, "%02d:%02d:%02d", timeptr->tm_hour, timeptr->tm_min, timeptr->tm_sec);
                  dylib.strcat (s, st);
                  break;
               case 'D':
                  sprintf (st, "%02d/%02d/%02d", timeptr->tm_mon, timeptr->tm_mday, timeptr->tm_year);
                  dylib.strcat (s, st);
                  break;
               case 'j':
                  sprintf (st, "%03d", timeptr->tm_yday + 1);
                  dylib.strcat (s, st);
                  break;
               case 'w':
                  sprintf (st, "%d", timeptr->tm_wday);
                  dylib.strcat (s, st);
                  break;
               case 'u':
                  sprintf (st, "%d", timeptr->tm_wday + 1);
                  dylib.strcat (s, st);
                  break;
               case '%':
                  strncat (s, p, 1);
                  break;
               default:
                  r = 0;
                  break;

            }
            in_escape = false;
         }  else {
            // process outside of escape sequence
            if (*p == '%') {
               in_escape = true;        // move into an escape seqeunce
            } else {
               strncat (s, p, 1);   // regular character, just append
            }
         }

         p++;                           // advance the pointer
      }
      if (in_escape) {                  // ensure the format didn't terminate with an escape
         r = 0;
      }           
                  
   } else {
      r = 0;
   }    

   if (r) {
      r = dylib.strlen (s);
   }

   return r;
}
