/* strncmp.c
   This method compares strings up to n characters.
   change log:
   11/15/2023 initial version
   12/10/2023 removed reference to string_ext.h
*/

#include <string.h>

int strncmp (const char *s1, const char *s2, int n) {
   int r = 0;                         // default returning strings equal
   for (int i = 0; i < n; i++) {      // loop up to the n - 1 character position
      if (*s1 == *s2 && *s1 == 0) {   // if both strings are null break
         break;
      }
      if (*s1 < *s2) {                // if s1 is less than s2 then return string 1 less than string 2; works with null char
         r = -1;
         break;
      }
      if (*s1 > *s2) {                // if s1 is more than s2 then return string 2 is more than string 2; works with null char
         r = 1;
         break;
      }
      s1++;                           // advance s1 and s2 one position
      s2++;
   }
   return r;                          // return the result
}
